/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity;

import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.util.GameProfile;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.velocity.events.SkinApplyVelocityEvent;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.utils.log.SRLogger;
import net.skinsrestorer.velocity.SkinsRestorer;

public class SkinApplierVelocity {
    private final SkinsRestorer plugin;
    private final SRLogger log;

    protected void applySkin(Player player, IProperty property) {
        this.plugin.getProxy().getEventManager().fire((Object)new SkinApplyVelocityEvent(player, property)).thenAccept(event -> {
            if (event.getResult() != ResultedEvent.GenericResult.allowed()) {
                return;
            }
            player.setGameProfileProperties(this.updatePropertiesSkin(player.getGameProfileProperties(), (GameProfile.Property)property.getHandle()));
            this.sendUpdateRequest(player, Config.FORWARD_TEXTURES ? (GameProfile.Property)property.getHandle() : null);
        });
    }

    public GameProfile updateProfileSkin(GameProfile profile, String skin) throws SkinRequestException {
        GameProfile.Property textures = (GameProfile.Property)this.plugin.getSkinStorage().getSkinForPlayer(skin).getHandle();
        List oldProperties = profile.getProperties();
        List<GameProfile.Property> newProperties = this.updatePropertiesSkin(oldProperties, textures);
        return new GameProfile(profile.getId(), profile.getName(), newProperties);
    }

    private List<GameProfile.Property> updatePropertiesSkin(List<GameProfile.Property> original, GameProfile.Property property) {
        ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>(original);
        boolean applied = false;
        int i = 0;
        for (GameProfile.Property lProperty : properties) {
            if ("textures".equals(lProperty.getName())) {
                properties.set(i, property);
                applied = true;
            }
            ++i;
        }
        if (!applied) {
            properties.add(property);
        }
        return properties;
    }

    private void sendUpdateRequest(Player player, GameProfile.Property textures) {
        player.getCurrentServer().ifPresent(serverConnection -> {
            this.log.debug("Sending skin update request for " + player.getUsername());
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("SkinUpdate");
                if (textures != null) {
                    out.writeUTF(textures.getName());
                    out.writeUTF(textures.getValue());
                    out.writeUTF(textures.getSignature());
                }
                serverConnection.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.create((String)"sr", (String)"skinchange"), b.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public SkinApplierVelocity(SkinsRestorer plugin, SRLogger log) {
        this.plugin = plugin;
        this.log = log;
    }
}

